//--------------------------------------------------------------------
// FILENAME:		DWEventSink.h
//
// Copyright(c) 2009 Motorola, Inc. All rights reserved.
//
// DESCRIPTION:		Simple C++ class object to use as a DataWedge API
//					Event Sink, This object handles
//
//					Start event
//					Stop event
//					Data Events 
//--------------------------------------------------------------------
#pragma once
#include "..\..\..\Include\DataWedge.h"
#include <atlbase.h>
#include <atlcom.h>

// DataWedge API event method descriptions
static _ATL_FUNC_INFO OnStartInfo = {CC_CDECL, VT_EMPTY, 0, {}};
static _ATL_FUNC_INFO OnStopInfo = {CC_CDECL, VT_EMPTY, 0, {}};
static _ATL_FUNC_INFO OnDataInfo = {CC_CDECL, VT_EMPTY, 1, {VT_BSTR}};

// Envent Sink ID
#define DW_API_CPPSAMPLE_EVENTSINK_ID	1234


//----------------------------------------------------------------------------
//  CLASS: CDWEventSink
//
//  PURPOSE: Implement DataWedge API Event sink object
//
//  COMMENTS:
//----------------------------------------------------------------------------
class CDWEventSink : public IDispEventSimpleImpl<DW_API_CPPSAMPLE_EVENTSINK_ID, CDWEventSink, &__uuidof(_IDataWedgeAPIEvents)>
{
private:
	// Main Application window handler
	HWND m_hMainWnd;
	// internally used windows message base
	// m_uiSinkMSgBase -> Start DataWedge
	// m_uiSinkMSgBase+1 -> Stop DataWedge
	// m_uiSinkMSgBase+2 -> DataWedge data event
	UINT m_uiSinkMSgBase;

public:
//----------------------------------------------------------------------------
//  FUNCTION: CDWEventSink()
//
//  PURPOSE: Default constructor.
//
//  COMMENTS:
//----------------------------------------------------------------------------
	CDWEventSink() 
	{
		m_hMainWnd=NULL;
		m_uiSinkMSgBase=0;
	};
//----------------------------------------------------------------------------
//  FUNCTION: CDWEventSink(HWND, UINT)
//
//  PURPOSE: A Constructor.
//
//  COMMENTS: Initialize the object with calling application window handler
//				and internal windows messages base
//----------------------------------------------------------------------------
	CDWEventSink(HWND hWnd, UINT uiMSGBase) 
	{
		m_hMainWnd=hWnd;
		m_uiSinkMSgBase=uiMSGBase;
	};

	// Event sink Map
	BEGIN_SINK_MAP(CDWEventSink)
		SINK_ENTRY_INFO(DW_API_CPPSAMPLE_EVENTSINK_ID, __uuidof(_IDataWedgeAPIEvents), 1, OnStart, &OnStartInfo)
		SINK_ENTRY_INFO(DW_API_CPPSAMPLE_EVENTSINK_ID, __uuidof(_IDataWedgeAPIEvents), 2, OnStop, &OnStopInfo)
		SINK_ENTRY_INFO(DW_API_CPPSAMPLE_EVENTSINK_ID, __uuidof(_IDataWedgeAPIEvents), 3, OnData, &OnDataInfo)	
	END_SINK_MAP()

//----------------------------------------------------------------------------
//  FUNCTION: OnStart()
//
//  PURPOSE: Handle on start event.
//
//  COMMENTS: 
//----------------------------------------------------------------------------
	// Onstart Event Handler implementation
	HRESULT __stdcall OnStart(void)
	{
		if (m_hMainWnd && m_uiSinkMSgBase!=0)
		{
			PostMessage(m_hMainWnd,m_uiSinkMSgBase,0,0);
		}
		return S_OK;
	}

//----------------------------------------------------------------------------
//  FUNCTION: OnStop()
//
//  PURPOSE: Handle on stop event.
//
//  COMMENTS: 
//----------------------------------------------------------------------------
	HRESULT __stdcall OnStop(void)
	{
		if (m_hMainWnd && m_uiSinkMSgBase!=0)
		{
			PostMessage(m_hMainWnd,m_uiSinkMSgBase+1,0,0);
		}
		return S_OK;
	}

//----------------------------------------------------------------------------
//  FUNCTION: OnData(BSTR)
//
//  PURPOSE: Handle on data event.
//
//  COMMENTS: 
//----------------------------------------------------------------------------
	HRESULT __stdcall OnData(BSTR bstrData)
	{
		if (m_hMainWnd && m_uiSinkMSgBase!=0)
		{
			SendMessage(m_hMainWnd,m_uiSinkMSgBase+2,(WPARAM) &bstrData,0);
		}
		return S_OK;
	}
};


