//--------------------------------------------------------------------
// FILENAME:		CPPDWAPISample.cpp
//
// Copyright(c) 2009 Motorola, Inc. All rights reserved.
//
// DESCRIPTION:		This simple application demonstrates
//					how to use the Motorola DataWedge API.
//					The API's used are as follows:
//
//					Start 
//					Stop 
//					Enable 
//					Disable
//					Get Status
//					On Start Event
//					On Stop Event
//					On Data Event
//
//--------------------------------------------------------------------
#include "stdafx.h"
#include <windows.h>
#include "resource.h"
#include "DWEventSink.h"

#define MAX_LOADSTRING 100
// DataWedge Event sink messages base UM_DWAPI_MGS_BASE->Start DataWedge
// UM_DWAPI_MGS_BASE+1 -> Stop DataWedge
// UM_DWAPI_MGS_BASE+2 -> DataWedge data event
#define UM_DWAPI_MGS_BASE	WM_USER+200


// Global Variables:
HINSTANCE			g_hInst;			// current instance

// Forward declarations of functions included in this code module:
ATOM			MyRegisterClass(HINSTANCE, LPTSTR);
BOOL			InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);

// DataWedge event sink object pointer
CDWEventSink *g_eventSink=NULL;
// COM Smart pointer object to manage DataWedge API interface object
CComPtr<IDataWedgeAPI> g_srcObj;
// Child controls array
HWND g_hwndCtrls[8];

// Temorary variables to use in message loop   function
TCHAR g_szTemp[MAX_LOADSTRING];
TCHAR g_szTemp1[MAX_LOADSTRING];
HWND g_hTemp=NULL;
// Scalling FActor
UINT g_uiXScale, g_uiYScale;

#define SCALEX96(x) (x*g_uiXScale/96)
#define SCALEY96(y) (y*g_uiYScale/96)

//----------------------------------------------------------------------------
//
//  FUNCTION:   WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
//
//  PURPOSE:    Entry point function, initializes the application, instance,
//              and then launches the message loop.
//
//  PARAMETERS:
//      hInstance     - handle that uniquely identifies this instance of the
//                      application
//      hPrevInstance - always zero in Win32
//      lpszCmdLine   - any command line arguements pass to the program
//      nCmdShow      - the state which the application shows itself on
//                      startup
//
//  RETURN VALUE:
//      (int) Returns the value from PostQuitMessage().
//
//----------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPTSTR    lpCmdLine,
                   int       nCmdShow)
{
	MSG msg;
	CoInitializeEx(NULL,0);

	// Perform application initialization:
	if (!InitInstance(hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	HACCEL hAccelTable;
	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_CPPDWAPISAMPLE));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	if (g_eventSink) 
	{
		g_eventSink->DispEventUnadvise(g_srcObj);
		delete g_eventSink;
		g_eventSink=NULL;
	}
	g_srcObj.Release();
	CoUninitialize();

	return (int) msg.wParam;
}


//----------------------------------------------------------------------------
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//----------------------------------------------------------------------------
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS wc;

	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_CPPDWAPISAMPLE));
	wc.hCursor       = 0;
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName  = 0;
	wc.lpszClassName = szWindowClass;

	return RegisterClass(&wc);
}


//----------------------------------------------------------------------------
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.

//----------------------------------------------------------------------------
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    HWND hWnd;
    TCHAR szTitle[MAX_LOADSTRING];		// title bar text
    TCHAR szWindowClass[MAX_LOADSTRING];	// main window class name

    g_hInst = hInstance; // Store instance handle in our global variable


    LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING); 
    LoadString(hInstance, IDC_CPPDWAPISAMPLE, szWindowClass, MAX_LOADSTRING);

    //If it is already running, then focus on the window, and exit
    hWnd = FindWindow(szWindowClass, szTitle);	
    if (hWnd) 
    {
        // set focus to foremost child window
        // The "| 0x00000001" is used to bring any owned windows to the foreground and
        // activate them.
        SetForegroundWindow((HWND)((ULONG) hWnd | 0x00000001));
        return 0;
    } 

    if (!MyRegisterClass(hInstance, szWindowClass))
    {
    	return FALSE;
    }

    hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

    if (!hWnd)
    {
        return FALSE;
    }


    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);


    return TRUE;
}



//----------------------------------------------------------------------------
//  FUNCTION: UpdateStatus()
//
//  PURPOSE:  Update current status of datawedge.
//
//  Comment : 
//----------------------------------------------------------------------------
void UpdateDWStatus()
{
	if (NULL != g_eventSink && NULL!=g_hwndCtrls[0])
	{
		LONG lStatus;
		if (S_OK==g_srcObj->get_status(&lStatus))
		{
			if (DW_STATUS_STOPPED==lStatus) 
			{
				PostMessage (g_hwndCtrls[0], BM_SETCHECK, BST_UNCHECKED, 0) ;
			}
			else if (DW_STATUS_READY==lStatus)
			{
				PostMessage (g_hwndCtrls[0], BM_SETCHECK, BST_CHECKED, 0) ;
			}
			else
			{
				PostMessage (g_hwndCtrls[0], BM_SETCHECK, BST_INDETERMINATE, 0) ;
			}
		}
	}
}

//----------------------------------------------------------------------------
//  FUNCTION: GetStatusText()
//
//  PURPOSE:  Get current status in text form.
//
//  Comment : Input buffer should be MAX_LOADSTRING in length
//----------------------------------------------------------------------------
void GetStatusText()
{
	LoadString(g_hInst, IDS_STATUS_GET_FAILED, g_szTemp, MAX_LOADSTRING); // Default status message
	if (NULL != g_eventSink)
	{
		LONG lStatus;
		if (S_OK==g_srcObj->get_status(&lStatus))
		{
			if (DW_STATUS_READY==lStatus)
			{
				// DataWedge is running
				LoadString(g_hInst, IDS_STATUS_RUNNING, g_szTemp, MAX_LOADSTRING);
			}
			else if (DW_STATUS_IDLE==lStatus)
			{
				// No Capture devices
				LoadString(g_hInst, IDS_STATUS_NO_INPUT_DEVICES, g_szTemp, MAX_LOADSTRING);
			}
			else if (DW_STATUS_SLEEPING==lStatus)
			{
				// A Profile is not loaded
				LoadString(g_hInst, IDS_STATUS_PROFILE_DISABLED, g_szTemp, MAX_LOADSTRING);
			}
			else if (DW_STATUS_DISABLED==lStatus)
			{
				// DataWedge Disabled
				LoadString(g_hInst, IDS_STATUS_DISABLED, g_szTemp, MAX_LOADSTRING);
			}
			else
			{
				// Not Running
				LoadString(g_hInst, IDS_STATUS_NOT_RUNNING , g_szTemp, MAX_LOADSTRING);
			}
		}
	}
}

//----------------------------------------------------------------------------
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu/ control actions
//		IDM_OK		- Close Application
//		IDM_START	- Start DataWedge
//		IDM_STOP	- Stop DataWedge
//		IDM_ENABLE  - Enable DataWedge
//		IDM_DISABLE - Disable DataWedge
//		IDM_GETSTATUS - Get Current status of the DataWedge
//  WM_CREATE	- Create and initialize all controls associated with the sample
//  Other		- Other messages are normally messages required for a
//					windows application
//
//----------------------------------------------------------------------------

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    int wmId, wmEvent;
    PAINTSTRUCT ps;
    HDC hdc;
	VARIANT_BOOL bResult, bPersist;

	
    switch (message) 
    {
        case WM_COMMAND:
            wmId    = LOWORD(wParam); 
            wmEvent = HIWORD(wParam); 
            // Parse the menu selections:
			if (IDM_OK==wmId)
			{
				SendMessage (hWnd, WM_CLOSE, 0, 0);	
			}
			else
			{
				if (NULL != g_eventSink)
				{           
					switch (wmId)
					{

						case IDM_START:
							// Start DataWedge
							if (S_FALSE==g_srcObj->Start(&bResult) 
								|| VARIANT_FALSE==bResult)
							{						
								LoadString(g_hInst, IDS_MSG_START_FAILED, g_szTemp, MAX_LOADSTRING);
								LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); 
								MessageBox(hWnd,g_szTemp,g_szTemp1,0);
							}
							break;
						case IDM_STOP:
							// Stop DataWedge
							if (S_FALSE==g_srcObj->Stop(&bResult) 
								|| VARIANT_FALSE==bResult )
							{
								LoadString(g_hInst, IDS_MSG_STOP_FAILED, g_szTemp, MAX_LOADSTRING);
								LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); 
								MessageBox(hWnd,g_szTemp,g_szTemp1,0);
							}
							break;
						case IDM_ENABLE:
							// Enable DataWedge
							bPersist=VARIANT_FALSE;
							if (NULL != g_hwndCtrls[5])
							{
								if(SendMessage(g_hwndCtrls[5], BM_GETCHECK, 0, 0))
								{
									// Enable datawedge permenetly
									bPersist=VARIANT_TRUE;
								}
							}
							if (S_FALSE==g_srcObj->Enable(bPersist,&bResult) 
								|| VARIANT_FALSE==bResult )
							{
								LoadString(g_hInst, IDS_MSG_ENABLE_FAILED, g_szTemp, MAX_LOADSTRING);
								LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); 
								MessageBox(hWnd,g_szTemp,g_szTemp1,0);
							}
							break;
						case IDM_DISABLE:
							// Disable DataWedge
							bPersist=VARIANT_FALSE;
							if (NULL != g_hwndCtrls[5])
							{
								if(SendMessage(g_hwndCtrls[5], BM_GETCHECK, 0, 0))
								{
									// Enable datawedge permenetly
									bPersist=VARIANT_TRUE;
								}
							}
							if (S_FALSE==g_srcObj->Disable(bPersist,&bResult) 
								|| VARIANT_FALSE==bResult )
							{
								LoadString(g_hInst, IDS_MSG_DISABLE_FAILED, g_szTemp, MAX_LOADSTRING);
								LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); 
								MessageBox(hWnd,g_szTemp,g_szTemp1,0);
							}
							break;
						case IDM_GETSTATUS:
							// Get DataWedge Staus 
							GetStatusText();
							LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); // Status window Title
							// Show status message box
							MessageBox(hWnd,g_szTemp,g_szTemp1,0);
							break;
						default:
							return DefWindowProc(hWnd, message, wParam, lParam);
					}	
				}
				else
				{
						LoadString(g_hInst, IDS_MSG_DWNOTINSTALLED, g_szTemp, MAX_LOADSTRING);
						LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); 
						MessageBox(hWnd,g_szTemp,g_szTemp1,0);
				}

			}
            break;
		case UM_DWAPI_MGS_BASE+1:
			// DataWedge Stop Event notification, Uncheck DataWedge Runing Check box
			PostMessage (g_hwndCtrls[0], BM_SETCHECK, BST_UNCHECKED, 0) ;
			break;
		case UM_DWAPI_MGS_BASE:
			// DataWedge Start Event notification, update DataWedge status
		case UM_DWAPI_MGS_BASE+2:
			// Add Codes to handle other datawedge data events.
			// wparam - poiter to BSTR data associated with the data event
			// Here only check the current status to update status events
			UpdateDWStatus();
			break;

        case WM_CREATE:
			hdc=GetDC(hWnd);
			g_uiXScale=GetDeviceCaps(hdc,LOGPIXELSX);
			g_uiYScale=GetDeviceCaps(hdc,LOGPIXELSY);

			// Create DataWedge is Running Check box
			LoadString(g_hInst, IDS_RUNNING_STATUS, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[0]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD|BS_3STATE ,SCALEX96(10), SCALEY96(10), SCALEX96(200), SCALEY96(20),hWnd,(HMENU) IDM_CHKBX_RUNING , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[0],SW_SHOWNORMAL);
			// Line Seperator
			g_hTemp=CreateWindow (L"BUTTON", NULL,WS_CHILD,0, SCALEY96(35), SCALEX96(600), SCALEY96(1)+1,hWnd, 0, g_hInst, NULL) ;
			ShowWindow(g_hTemp,SW_SHOWNORMAL);
			// Create Start buttons
			LoadString(g_hInst, IDS_STRAT_DW, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[1]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_PUSHBUTTON,SCALEX96(10), SCALEY96(40), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_START , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[1],SW_SHOWNORMAL);	
			// Create Stop buttons
			LoadString(g_hInst, IDS_STOP_DW, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[2]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_PUSHBUTTON,SCALEX96(80), SCALEY96(40), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_STOP , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[2],SW_SHOWNORMAL);
			// Line Seperator
			g_hTemp=CreateWindow (L"BUTTON", NULL,WS_CHILD,0, SCALEY96(65), SCALEX96(600), SCALEY96(2),hWnd, 0, g_hInst, NULL) ;
			ShowWindow(g_hTemp,SW_SHOWNORMAL);
			// Create Enable buttons
			LoadString(g_hInst, IDS_ENABLE_DW, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[3]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_PUSHBUTTON,SCALEX96(10), SCALEY96(70), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_ENABLE , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[3],SW_SHOWNORMAL);
			// Create Disable buttons
			LoadString(g_hInst, IDS_DISABLE_DW, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[4]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_PUSHBUTTON,SCALEX96(80), SCALEY96(70), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_DISABLE , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[4],SW_SHOWNORMAL);
			// Create Persist Check Box
			LoadString(g_hInst, IDS_PERSIST, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[5]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_AUTOCHECKBOX ,SCALEX96(150), SCALEY96(70), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_PERSIST , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[5],SW_SHOWNORMAL);	
			SendMessage (g_hwndCtrls[5], BM_SETCHECK, TRUE, 0) ; // Checked by default
			// Line Seperator
			g_hTemp=CreateWindow (L"BUTTON", NULL,WS_CHILD,0, SCALEY96(95), SCALEX96(600), SCALEY96(1)+1,hWnd, 0, g_hInst, NULL) ;
			ShowWindow(g_hTemp,SW_SHOWNORMAL);
			// Create Status buttons
			LoadString(g_hInst, IDS_STATUS_DW, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[6]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_PUSHBUTTON,SCALEX96(10), SCALEY96(100), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_GETSTATUS , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[6],SW_SHOWNORMAL);	
			// Line Seperator
			g_hTemp=CreateWindow (L"BUTTON", NULL,WS_CHILD,0, SCALEY96(125), SCALEX96(600), SCALEY96(1)+1,hWnd, 0, g_hInst, NULL) ;
			ShowWindow(g_hTemp,SW_SHOWNORMAL);
			// Create Close buttons
			LoadString(g_hInst, IDS_OK, g_szTemp, MAX_LOADSTRING); 
			g_hwndCtrls[7]=CreateWindow (L"BUTTON", g_szTemp,WS_CHILD | BS_PUSHBUTTON,SCALEX96(10), SCALEY96(130), SCALEX96(60), SCALEY96(20),hWnd, (HMENU) IDM_OK , g_hInst, NULL) ;
			ShowWindow(g_hwndCtrls[7],SW_SHOWNORMAL);	 
			// Line Seperator
			g_hTemp=CreateWindow (L"BUTTON", NULL,WS_CHILD,0, SCALEY96(155), SCALEX96(600), SCALEY96(1)+1,hWnd, 0, g_hInst, NULL) ;
			ShowWindow(g_hTemp,SW_SHOWNORMAL);

			// Create DataWedge API Object
			if (S_OK==g_srcObj.CoCreateInstance(OLESTR("DataWedge.API")))
			{
				LONG lStatus=0;
				g_eventSink=new CDWEventSink(hWnd,UM_DWAPI_MGS_BASE);
				// Advise DataWedge Event sink object
				g_eventSink->DispEventAdvise(g_srcObj);
				UpdateDWStatus();
			}
			else
			{
				LoadString(g_hInst, IDS_MSG_DWNOTINSTALLED, g_szTemp, MAX_LOADSTRING);
				LoadString(g_hInst, IDS_STATUS_WND_TITLE, g_szTemp1, MAX_LOADSTRING); 
				MessageBox(hWnd,g_szTemp,g_szTemp1,0);
			}

            break;
        case WM_PAINT:
            hdc = BeginPaint(hWnd, &ps);
            
            // TODO: Add any drawing code here...
            
            EndPaint(hWnd, &ps);
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;


        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}
